<?php if (!defined('PmWiki')) exit();

include_once("scripts/xlpage-utf-8.php");

## Site title
$WikiTitle = 'Wiki';
$WikiTag = '';

## Logo image
$PageLogoUrl = "$PubDirUrl/Logo.png";
$PageLogoUrlWidth = '85px';
#$PageLogoUrlWidth = '0px';

## Skin selection
$Skin = 'skittlish';
$SkinStyle = 'fixed';
$SkinColor = 'gray';

## Default passwords
$DefaultPasswords['admin'] = 'atfauIJ90ODzk';
$DefaultPasswords['attr'] = 'atfauIJ90ODzk';
$DefaultPasswords['edit'] = 'atfauIJ90ODzk';

## Upload password
$EnableUpload = 1;
$UploadMaxSize = 20000000;
$DefaultPasswords['upload'] = 'atfauIJ90ODzk';

## History password
$HandleAuth['diff'] = 'edit';
$DiffKeepDays = 30; # keep revisions at least 30 days

## Enable / path style
$EnablePathInfo=1;

## Enable C/C++ upload
$UploadExts['c'] = 'text/plain';
$UploadExts['h'] = 'text/plain';
$UploadExts['cpp'] = 'text/plain';

## Enable SVG inline and upload
include_once("cookbook/svg.php");
$UploadExts['svg'] = 'image/svg+xml';

## Misc file extensions
$UploadExts['sh'] = 'text/plain';
$UploadExts['blend'] = 'application/vnd.blender.blend';
$UploadExts['ogv'] = 'video/ogg';
$UploadExts['ogg'] = 'video/ogg';
$UploadExts['mp4'] = 'video/mp4';
$UploadExts['webm'] = 'video/webm';
$UploadExts['wmv'] = 'video/wmv';

## Enable HTML5 video for .ogv (Firefox)
include_once("cookbook/HTML5Video.php");
$HTML5VideoDir = '../../uploads/';

## Enable youtube video
include_once("cookbook/swf-sites.php");

## Enable deletion of attachments
include_once("cookbook/attachdel.php");

## Enable MarkupExtensions
include_once("cookbook/extendmarkup.php");
include_once("cookbook/break_page.php");

## Enable LaTeXMathML
include_once("cookbook/LaTeXMathML.php");

## Enable PublishWikiTrail
include_once("local/publish.php");
$IncludeModifiedDate=false;

## Enable Mini Thumbnails
include_once("cookbook/mini.php");
$Mini['thumbs'][0] = "300x300";
$Mini['EnableLightbox'] = 1;
$Mini['EnableHeaderFooter'] = 1;

## Enable Source Block
include_once("cookbook/sourceblock.php");

## Add Source Block Markup
Markup('csourceblock', '>markupend',
  "/\\(:c(\\s+.*?)?\\s*:\\)[^\\S\n]*\\[([=@])(.*?)\\2\\]/sei",
  "SourceBlockMarkup(\$pagename, PSS('$1 lang=c'), PSS('$3'))");
Markup('cppsourceblock', '>markupend',
  "/\\(:cpp(\\s+.*?)?\\s*:\\)[^\\S\n]*\\[([=@])(.*?)\\2\\]/sei",
  "SourceBlockMarkup(\$pagename, PSS('$1 lang=cpp'), PSS('$3'))");

## Add Actual Time Markup
Markup('time', 'directives',
 '/\\(:time:\\)/',
 Keep("
<script type='text/javascript'>
<!--
var currentTime = new Date();

var hours = currentTime.getHours();
var minutes = currentTime.getMinutes();
if (minutes<10) minutes = '0' + minutes;

if (hours>=12) document.write(hours-12 + ':' + minutes + 'pm');
else document.write(hours + ':' + minutes + 'am');
//-->
</script>
 ") );

## Add Actual Date Markup
Markup('date', 'directives',
 '/\\(:date:\\)/',
 Keep("
<script type='text/javascript'>
<!--
var currentTime = new Date();

var day = currentTime.getDate();
var month = currentTime.getMonth()+1;
var year = currentTime.getFullYear();

document.write(day + '.' + month + '.' + year);
//-->
</script>
 ") );

## Enable forum
include_once('cookbook/forum3.php');

## The refcount.php script enables ?action=refcount
if ($action == 'refcount') include_once("scripts/refcount.php");

## Enable ?action=project to include corresponding style sheet
if ($action == 'project') {
   $HTMLHeaderFmt['project'] = '<link rel="stylesheet" type="text/css" href="$SkinDirUrl/project.css" />';
   $LinkPageExistsFmt = "<a class='wikilink' href='\$PageUrl?action=project'>\$LinkText</a>";
}

## Add expirediff action to history listing
include_once('cookbook/expirediff.php');
if ($action == 'diff') {
  $ExpireDiffFmt = <<<_EOT_
<div id='wikiexpire'>
  <form action='\$PageUrl' method='post'>
    <input type='hidden' name='action' value='expirediff' />
    <input type='hidden' name='n' value='\$FullName' />
    <p>Expire difference(s) older than
      <input type='text' name='keepdays' value='0' /> day(s)</p>
    <input type='submit' />
  </form>
</div>
_EOT_;
  $HandleDiffFmt = array(&$PageStartFmt, &$PageDiffFmt,
                         'function:PrintDiff',
                         &$ExpireDiffFmt, &$PageEndFmt);
}
